# -*- coding: utf-8 -*-
from events.celery_app import app
from events.common_app.metrics.solomon import Tokens, SolomonMetrics


@app.task
def cleanup_celery():
    from django.core.management import call_command
    call_command('cleanup_celery')


@app.task
def token_expired_metrics():
    tokens = Tokens()
    data = tokens.get_expired_in_days()
    metrics = SolomonMetrics()
    metrics.write_metrics(data)
