# -*- coding: utf-8 -*-
from django.http import HttpResponse, JsonResponse
from django.views.generic.base import TemplateView, View
from django.utils.translation import ugettext_lazy as _

from events.common_app.utils import get_version
from events.rest_framework_contrib.mixins import GenericViewV1Mixin


class RobotsView(TemplateView):
    template_name = 'common_app/robots.txt'

    def render_to_response(self, context, **response_kwargs):
        response = super(RobotsView, self).render_to_response(context, **response_kwargs)
        response['Content-Type'] = 'text/plain'
        return response


class VersionView(GenericViewV1Mixin, View):
    def get(self, request, *args, **kwargs):
        return HttpResponse(get_version())


class HttpErrorResponse(JsonResponse):
    default_detail = ''

    def __init__(self):
        return super().__init__({'detail': self.default_detail})


class Http404Response(HttpErrorResponse):
    status_code = 404
    default_detail = _('Not found.')
