# -*- coding: utf-8 -*-
import yenv

from django.conf import settings
from yt.wrapper import YtClient


def get_client(cluster=None):
    cluster = cluster or 'hahn'
    config = {
        'token': settings.YT_TOKEN,
    }
    return YtClient(cluster, config=config)


def get_acl(client, folder_path):
    for folder in client.list(folder_path, attributes=['acl'], absolute=True):
        yield str(folder), folder.attributes['acl']


def delete_path(client, path):
    client.remove(path, recursive=True, force=True)


def get_yt_path(survey_id, app_type=None, yenv_type=None):
    home_path = settings.YT_ANSWERS_HOME_PATH
    app_type = app_type or settings.APP_TYPE
    if app_type == 'forms_ext_admin':
        app_type = 'forms_ext'
    yenv_type = yenv_type or yenv.type
    return '/'.join([home_path, app_type, yenv_type, str(survey_id)])


def get_yt_url(survey_id):
    path = get_yt_path(survey_id)
    return settings.YT_URL_FORMAT.format(cluster='hahn', path=path)


def decode(raw_string):
    return raw_string.decode().encode('raw_unicode_escape').decode()
