# -*- coding: utf-8 -*-
from django.conf import settings
from urllib.parse import quote_plus


def get_mds_url(path, tld=None):
    tld = tld or settings.DEFAULT_TLD
    domain = settings.FRONTEND_DOMAIN.format(tld=tld)
    return 'https://{domain}{path_prefix}/files?path={path}'.format(
        domain=domain,
        path_prefix=settings.FILE_PATH_PREFIX,
        path=quote_plus(path),
    )
