# -*- coding: utf-8 -*-
import factory
from django.contrib.contenttypes.models import ContentType

from events.conditions.models import ContentTypeAttribute
from events.surveyme.models import ProfileSurveyAnswer


class ContentTypeAttributeFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = ContentTypeAttribute

    title = ''
    lookup_field = 'pk'
    allowed_conditions=['eq', 'neq'],
    content_type = factory.LazyAttribute(
        lambda o: ContentType.objects.get_for_model(ProfileSurveyAnswer))
