# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand
from events.countme.utils import rebuild_counters


class Command(BaseCommand):
    help = """Пересчитать счетчики для формы или списка форм"""

    def add_arguments(self, parser):
        parser.add_argument('surveys', metavar='survey_id', type=str, nargs='+',
                            help='код формы')

    def handle(self, *args, **options):
        for survey_id in options['surveys']:
            rebuild_counters(survey_id)
