# Generated by Django 2.2.17 on 2020-12-17 06:26

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('surveyme', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AnswerCount',
            fields=[
                ('survey', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='surveyme.Survey')),
                ('count', models.IntegerField(default=0)),
                ('last_modified', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='QuestionScoresCountByDate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('scores', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('created', models.DateField()),
                ('count', models.IntegerField(default=0)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.SurveyQuestion')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.Survey')),
            ],
            options={
                'unique_together': {('question', 'scores', 'created')},
            },
        ),
        migrations.CreateModel(
            name='QuestionScoresCount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('scores', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('count', models.IntegerField(default=0)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.SurveyQuestion')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.Survey')),
            ],
            options={
                'unique_together': {('question', 'scores')},
            },
        ),
        migrations.CreateModel(
            name='QuestionGroupDepth',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('depth', models.IntegerField(default=0)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.SurveyQuestion')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.Survey')),
            ],
            options={
                'unique_together': {('question',)},
            },
        ),
        migrations.CreateModel(
            name='QuestionCountByDate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('composite_key', models.CharField(max_length=32, null=True)),
                ('created', models.DateField()),
                ('count', models.IntegerField(default=0)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.SurveyQuestion')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.Survey')),
            ],
            options={
                'unique_together': {('question', 'composite_key', 'created')},
            },
        ),
        migrations.CreateModel(
            name='QuestionCount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('composite_key', models.CharField(max_length=32, null=True)),
                ('count', models.IntegerField(default=0)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.SurveyQuestion')),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.Survey')),
            ],
            options={
                'unique_together': {('question', 'composite_key')},
            },
        ),
        migrations.CreateModel(
            name='AnswerScoresCountByDate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('scores', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('created', models.DateField()),
                ('count', models.IntegerField(default=0)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.Survey')),
            ],
            options={
                'unique_together': {('survey', 'scores', 'created')},
            },
        ),
        migrations.CreateModel(
            name='AnswerScoresCount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('scores', models.DecimalField(decimal_places=2, default=0.0, max_digits=10)),
                ('count', models.IntegerField(default=0)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.Survey')),
            ],
            options={
                'unique_together': {('survey', 'scores')},
            },
        ),
        migrations.CreateModel(
            name='AnswerCountByDate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateField()),
                ('count', models.IntegerField(default=0)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='surveyme.Survey')),
            ],
            options={
                'unique_together': {('survey', 'created')},
            },
        ),
    ]
