# -*- coding: utf-8 -*-
from django.db import models

MAX_COMPOSITE_KEY = 32


class AnswerCount(models.Model):
    survey = models.OneToOneField('surveyme.Survey', on_delete=models.CASCADE, primary_key=True)
    count = models.IntegerField(default=0)
    last_modified = models.DateTimeField(auto_now=True)


class AnswerCountByDate(models.Model):
    survey = models.ForeignKey('surveyme.Survey', on_delete=models.CASCADE, related_name='+')
    created = models.DateField()
    count = models.IntegerField(default=0)

    class Meta:
        unique_together = ('survey', 'created')


class QuestionCount(models.Model):
    survey = models.ForeignKey('surveyme.Survey', on_delete=models.CASCADE, related_name='+')
    question = models.ForeignKey('surveyme.SurveyQuestion', on_delete=models.CASCADE, related_name='+')
    composite_key = models.CharField(max_length=MAX_COMPOSITE_KEY, null=True)
    count = models.IntegerField(default=0)

    class Meta:
        unique_together = ('question', 'composite_key')


class QuestionCountByDate(models.Model):
    survey = models.ForeignKey('surveyme.Survey', on_delete=models.CASCADE, related_name='+')
    question = models.ForeignKey('surveyme.SurveyQuestion', on_delete=models.CASCADE, related_name='+')
    composite_key = models.CharField(max_length=MAX_COMPOSITE_KEY, null=True)
    created = models.DateField()
    count = models.IntegerField(default=0)

    class Meta:
        unique_together = ('question', 'composite_key', 'created')


class AnswerScoresCount(models.Model):
    survey = models.ForeignKey('surveyme.Survey', on_delete=models.CASCADE, related_name='+')
    scores = models.DecimalField(max_digits=10, decimal_places=2, default=0.0)
    count = models.IntegerField(default=0)

    class Meta:
        unique_together = ('survey', 'scores')


class AnswerScoresCountByDate(models.Model):
    survey = models.ForeignKey('surveyme.Survey', on_delete=models.CASCADE, related_name='+')
    scores = models.DecimalField(max_digits=10, decimal_places=2, default=0.0)
    created = models.DateField()
    count = models.IntegerField(default=0)

    class Meta:
        unique_together = ('survey', 'scores', 'created')


class QuestionScoresCount(models.Model):
    survey = models.ForeignKey('surveyme.Survey', on_delete=models.CASCADE, related_name='+')
    question = models.ForeignKey('surveyme.SurveyQuestion', on_delete=models.CASCADE, related_name='+')
    scores = models.DecimalField(max_digits=10, decimal_places=2, default=0.0)
    count = models.IntegerField(default=0)

    class Meta:
        unique_together = ('question', 'scores')


class QuestionScoresCountByDate(models.Model):
    survey = models.ForeignKey('surveyme.Survey', on_delete=models.CASCADE, related_name='+')
    question = models.ForeignKey('surveyme.SurveyQuestion', on_delete=models.CASCADE, related_name='+')
    scores = models.DecimalField(max_digits=10, decimal_places=2, default=0.0)
    created = models.DateField()
    count = models.IntegerField(default=0)

    class Meta:
        unique_together = ('question', 'scores', 'created')


class QuestionGroupDepth(models.Model):
    survey = models.ForeignKey('surveyme.Survey', on_delete=models.CASCADE, related_name='+')
    question = models.ForeignKey('surveyme.SurveyQuestion', on_delete=models.CASCADE, related_name='+')
    depth = models.IntegerField(default=0)

    class Meta:
        unique_together = ('question', )
