# -*- coding: utf-8 -*-
from copy import copy
from django.conf import settings
from django.http import Http404
from requests.exceptions import Timeout
from rest_framework import viewsets

from rest_framework.response import Response
from rest_framework import status
from django.core.exceptions import ValidationError, PermissionDenied

from events.rest_framework_contrib.mixins import ExternalGenericApiViewV1Mixin
from events.data_sources.sources import data_sources_list
from events.surveyme_integration.exceptions import PermissionError


class DataSourceBaseViewSet(ExternalGenericApiViewV1Mixin, viewsets.ReadOnlyModelViewSet):
    # todo: test me
    data_source_class = None
    create_on_missing = False

    def get_queryset(self):
        return None

    def filter_queryset(self, *args, **kwargs):
        user = self.request.user
        return self.data_source_class(
            user=user,
            language=self.request.LANGUAGE_CODE,
            request=self.request,
        ).get_filtered_queryset(
            filter_data=self.get_filter_data(),
        ) or []

    def get_filter_data(self):
        filter_data = copy(self.request.query_params)
        if settings.IS_BUSINESS_SITE:
            if 'survey' in filter_data:
                filter_data.update(self.get_survey_data(filter_data.get('survey')))
        return filter_data

    def get_survey_data(self, survey_id):
        from events.surveyme.models import Survey
        try:
            user_uid, dir_id = (
                Survey.objects.select_related(
                    'org',
                    'user',
                )
                .values_list(
                    'user__uid',
                    'org__dir_id',
                )
                .get(pk=survey_id)
            )
            return {
                'user_uid': user_uid,
                'dir_id': dir_id,
            }
        except Survey.DoesNotExist:
            raise Http404

    def get_serializer_class(self):
        return self.data_source_class.serializer_class

    def list(self, request, *args, **kwargs):
        try:
            return super(DataSourceBaseViewSet, self).list(request, *args, **kwargs)
        except ValidationError as exc:
            return Response(str(exc), status=status.HTTP_400_BAD_REQUEST)
        except (PermissionError, PermissionDenied) as exc:
            return Response(str(exc), status=status.HTTP_403_FORBIDDEN)
        except Timeout as exc:
            return Response(str(exc), status=status.HTTP_408_REQUEST_TIMEOUT)


data_source_view_sets = []

for data_source in data_sources_list:
    if data_source.name not in ('survey_question_choice', 'survey_question_matrix_choice'):
        class DataSourceViewSet(data_source.get_view_class()):
            data_source_class = data_source
        data_source_view_sets.append(DataSourceViewSet)
