# -*- coding: utf-8 -*-
from rest_framework import serializers
import collections.abc


class DataSourceCategorySerializer(serializers.Serializer):
    name = serializers.CharField()
    title = serializers.CharField()


class DataSourceSerializer(serializers.Serializer):
    name = serializers.CharField()
    title = serializers.CharField()
    desc = serializers.CharField()
    uri = serializers.SerializerMethodField('get_admin_uri')
    category = DataSourceCategorySerializer()
    allow_external_usage = serializers.ReadOnlyField()
    is_with_pagination = serializers.BooleanField()
    allowed_filters = serializers.SerializerMethodField()
    content_type = serializers.SerializerMethodField()
    items = serializers.SerializerMethodField('get_admin_items')
    hint = serializers.BooleanField()
    connect_only = serializers.BooleanField()

    def get_content_type(self, obj):
        return obj().get_content_type_id()

    def get_allowed_filters(self, obj):
        # todo: test me
        if obj.filter_class:
            response = []
            declared_filters = getattr(obj.filter_class, 'declared_filters', {})
            if isinstance(declared_filters, collections.abc.Callable):
                declared_filters = declared_filters()
            for key, value in declared_filters.items():
                if hasattr(value, 'data_source'):
                    response.append({
                        'data_source': getattr(value, 'data_source'),
                        'name': key
                    })
            return response or None

    def get_admin_uri(self, obj):
        return obj().get_admin_uri()  # instantiate class

    def get_admin_items(self, obj):
        return obj().get_admin_items()  # instantiate class
