# -*- coding: utf-8 -*-
from rest_framework import views
from rest_framework.response import Response

from events.data_sources.sources import data_source_categories_list, data_sources_list
from events.data_sources.api_admin.v2.serializers import DataSourceCategorySerializer, DataSourceSerializer
from events.rest_framework_contrib.mixins import InternalGenericApiViewV2Mixin


class DataSourceCategoryView(InternalGenericApiViewV2Mixin, views.APIView):
    def get(self, request, *args, **kwargs):
        return Response(data=DataSourceCategorySerializer(data_source_categories_list, many=True).data)


class DataSourceView(InternalGenericApiViewV2Mixin, views.APIView):
    def get(self, request, *args, **kwargs):
        return Response(data=DataSourceSerializer(data_sources_list, many=True).data)
