# -*- coding: utf-8 -*-

from events.common_app.utils import add_model_prefix as add
from events.search.utils import ORMFullTextSearchConstructor


class UniversityConditions(object):
    @classmethod
    def is_fit_for_search_text(cls, search_text, model_instance=None, prefix=None):
        if model_instance:
            raise NotImplementedError()
        else:
            condition = ORMFullTextSearchConstructor(
                prefix=prefix,
                not_localizable_params=[
                    add(prefix, to='full_name'),
                ],
                is_full_text_search=True,
            ).get_q_objects_for_text(search_text=search_text)

        return condition
