# -*- coding: utf-8 -*-
import factory

from django.utils import timezone

from events.data_sources.models import TableMeta, TableRow, University


class TableRowFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = TableRow

    source_id = factory.Sequence(lambda n: str(n))


class TableMetaFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = TableMeta

    modification_time = factory.Sequence(lambda _: timezone.now())


class UniversityFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = University
