# Generated by Django 2.2.17 on 2020-12-17 06:26

from django.db import migrations, models
import django.utils.timezone
from events.common_app.jsonfield.fields import JSONField
from events.data_sources.sources.abc import AbcServiceDataSource
from events.data_sources.sources.external_table.wiki_table import WikiDataSource
from events.data_sources.sources.external_table.yt_table import YTDataSource
from events.data_sources.sources.generic import (
    AddressDataSource,
    CityDataSource,
    CountryDataSource,
    UniversityDataSource,
)
from events.data_sources.sources.music import MusicGenreDataSource
from events.data_sources.sources.staff import (
    StaffGroupDataSource,
    StaffLoginDataSource,
    StaffOrganizationDataSource,
    StaffOfficeDataSource,
)
from events.data_sources.sources.surveys import (
    SurveyQuestionChoiceDataSource,
    SurveyQuestionMatrixChoiceDataSource,
)
from events.data_sources.sources.user import (
    GenderDataSource,
    UserEmailListDataSource,
)
from events.data_sources.sources.webmaster import WebSiteDataSource


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='TableMeta',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('table_identifier', models.CharField(db_index=True, max_length=512)),
                ('modification_time', models.DateTimeField(default=django.utils.timezone.now)),
            ],
        ),
        migrations.CreateModel(
            name='TableRow',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('table_identifier', models.CharField(db_index=True, max_length=512)),
                ('source_id', models.CharField(blank=True, max_length=1000, null=True)),
                ('text', models.CharField(max_length=1000)),
                ('display_text', models.CharField(blank=True, max_length=1000, null=True)),
                ('filter_by', models.CharField(blank=True, max_length=1000, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='University',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=512)),
                ('city', models.CharField(blank=True, max_length=64)),
                ('region', models.CharField(blank=True, max_length=128)),
            ],
        ),
        migrations.CreateModel(
            name='DataSourceItem',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('translations', JSONField(blank=True, null=True)),
                ('data_source', models.CharField(choices=[('survey_question_choice', SurveyQuestionChoiceDataSource), ('survey_question_matrix_choice', SurveyQuestionMatrixChoiceDataSource), ('country', CountryDataSource), ('city', CityDataSource), ('university', UniversityDataSource), ('address', AddressDataSource), ('user_email_list', UserEmailListDataSource), ('wiki_table_source', WikiDataSource), ('gender', GenderDataSource), ('web_master_site', WebSiteDataSource), ('music_genre', MusicGenreDataSource), ('yt_table_source', YTDataSource), ('staff_login', StaffLoginDataSource), ('staff_group', StaffGroupDataSource), ('staff_organization', StaffOrganizationDataSource), ('staff_office', StaffOfficeDataSource), ('abc_service', AbcServiceDataSource)], max_length=100)),  # noqa
                ('identity', models.SlugField(max_length=100)),
                ('text', models.CharField(blank=True, max_length=1000)),
            ],
            options={
                'unique_together': {('data_source', 'identity')},
            },
        ),
    ]
