# -*- coding: utf-8 -*-
from django.db import models
from django.utils import timezone

from events.data_sources.sources import data_sources_choices
from events.data_sources.managers import DataSourceItemManager, UniversityManager
from events.translation.models import TranslationModel


class DataSourceItem(TranslationModel):
    FIELDS_FOR_TRANSLATION = ('text', )

    data_source = models.CharField(max_length=100, choices=data_sources_choices)
    identity = models.SlugField(max_length=100)
    text = models.CharField(max_length=1000, blank=True)

    objects = DataSourceItemManager()

    class Meta:
        unique_together = (('data_source', 'identity'),)

    def __str__(self):
        # todo: test me
        return self.get_text() or self.identity

    def get_text(self):
        return self.get_translated_field('text')


class University(models.Model):
    name = models.CharField(max_length=512)
    city = models.CharField(max_length=64, blank=True)
    region = models.CharField(max_length=128, blank=True)

    objects = UniversityManager()

    def __str__(self):
        return self.name


class TableRow(models.Model):
    table_identifier = models.CharField(max_length=512, db_index=True)
    source_id = models.CharField(max_length=1000, blank=True, null=True)
    text = models.CharField(max_length=1000)
    display_text = models.CharField(max_length=1000, blank=True, null=True)
    filter_by = models.CharField(max_length=1000, blank=True, null=True)


class TableMeta(models.Model):
    table_identifier = models.CharField(max_length=512, db_index=True)
    modification_time = models.DateTimeField(default=timezone.now)
