# -*- coding: utf-8 -*-
from django.conf import settings

from events.data_sources.sources.generic import (
    CityDataSource,
    CountryDataSource,
    UniversityDataSource,
    AddressDataSource,
)
from events.data_sources.sources.surveys import (
    SurveyQuestionChoiceDataSource,
    SurveyQuestionMatrixChoiceDataSource,
)
from events.data_sources.sources.user import (
    UserEmailListDataSource,
    GenderDataSource,
)
from events.data_sources.sources.staff import (
    StaffLoginDataSource,
    StaffGroupDataSource,
    StaffOrganizationDataSource,
    StaffOfficeDataSource,
)
from events.data_sources.sources.webmaster import (
    WebSiteDataSource,
)
from events.data_sources.sources.abc import (
    AbcServiceDataSource,
)
from events.data_sources.sources.music import (
    MusicGenreDataSource,
)
from events.data_sources.sources.directory import (
    DirUserDataSource,
    DirDepartmentDataSource,
    DirGroupDataSource,
)
from events.data_sources.sources.external_table.wiki_table import WikiDataSource
from events.data_sources.sources.external_table.yt_table import YTDataSource

data_sources_list = [
    SurveyQuestionChoiceDataSource,
    SurveyQuestionMatrixChoiceDataSource,

    CountryDataSource,
    CityDataSource,
    UniversityDataSource,
    AddressDataSource,

    UserEmailListDataSource,
    WikiDataSource,
    GenderDataSource,

    DirUserDataSource,
    DirDepartmentDataSource,
    DirGroupDataSource,
]

if not settings.IS_BUSINESS_SITE:
    data_sources_list += [
        WebSiteDataSource,
        MusicGenreDataSource,
        YTDataSource,
    ]

if settings.IS_INTERNAL_YANDEX_SERVICE:
    data_sources_list += [
        StaffLoginDataSource,
        StaffGroupDataSource,
        StaffOrganizationDataSource,
        StaffOfficeDataSource,

        AbcServiceDataSource,
    ]
else:
    WebSiteDataSource.hint = True
    MusicGenreDataSource.hint = True

data_source_categories_list = set(
    type(datasource.category)
    for datasource in data_sources_list
)

data_sources_choices = [(i.name, i) for i in data_sources_list]
data_sources_by_name = dict(data_sources_choices)
