# -*- coding: utf-8 -*-
import django_filters

from events.data_sources.filters import ListOrCommaSeparatedStringFilter
from events.abc.models import AbcService
from events.data_sources.sources.base import (
    BaseDataSourceCategory,
    BaseDataSource,
    SimpleDataSourceSerializer,
    TranslationDataSourceSerializerMixin,
)
from events.rest_framework_contrib import queryset_filters
from events.translation.filters import TranslationCharFilter


class AbsDataSourceCategory(BaseDataSourceCategory):
    name = 'abc'
    title = 'Каталог сервисов Яндекса'


class AbcServiceDataSourceSerializer(TranslationDataSourceSerializerMixin, SimpleDataSourceSerializer):
    id_attr = 'slug'
    text_attr = 'name'

    class Meta:
        fields = ('slug', 'name')


class AbcServiceDataSourceFilter(django_filters.FilterSet):
    id = ListOrCommaSeparatedStringFilter(field_name=AbcServiceDataSourceSerializer.id_attr)
    suggest = queryset_filters.OneValueMethodFilter(field_name='filter_by_fit_for_search_text')
    text = TranslationCharFilter(field_name=AbcServiceDataSourceSerializer.text_attr)
    is_deleted = django_filters.BooleanFilter()


class AbcServiceDataSource(BaseDataSource):
    name = 'abc_service'
    title = 'Сервис'
    desc = 'Сервис'
    category = AbsDataSourceCategory()
    allow_external_usage = True
    is_with_pagination = True
    is_need_auth = True
    is_for_external_site_type = False
    serializer_class = AbcServiceDataSourceSerializer
    filter_class = AbcServiceDataSourceFilter

    def get_queryset(self):
        return AbcService.objects.filter(is_deleted=False)
