# -*- coding: utf-8 -*-
import django_filters

from events.data_sources.filters import ListOrCommaSeparatedStringFilter
from events.music.models import MusicGenre
from events.data_sources.sources.base import (
    BaseDataSourceCategory,
    BaseDataSource,
    SimpleDataSourceSerializer,
    TranslationDataSourceSerializerMixin,
)
from events.rest_framework_contrib import queryset_filters
from events.translation.filters import TranslationCharFilter


class MusicGenreDataSourceCategory(BaseDataSourceCategory):
    name = 'music'
    title = 'Музыка'


class MusicGenreDataSourceSerializer(TranslationDataSourceSerializerMixin, SimpleDataSourceSerializer):
    id_attr = 'music_id'
    text_attr = 'title'

    class Meta:
        fields = ('music_id', 'title')


class MusicGenreDataSourceFilter(django_filters.FilterSet):
    id = ListOrCommaSeparatedStringFilter(field_name=MusicGenreDataSourceSerializer.id_attr)
    suggest = queryset_filters.OneValueMethodFilter(field_name='filter_by_fit_for_search_text')
    text = TranslationCharFilter(field_name=MusicGenreDataSourceSerializer.text_attr)
    is_deleted = False


class MusicGenreDataSource(BaseDataSource):
    name = 'music_genre'
    title = 'Жанр'
    desc = 'Жанры музыки'
    category = MusicGenreDataSourceCategory()
    allow_external_usage = True
    is_with_pagination = True
    is_need_auth = False
    is_for_external_site_type = False  # TODO уточнить что это за настройка
    serializer_class = MusicGenreDataSourceSerializer
    filter_class = MusicGenreDataSourceFilter
    hint = False

    def get_queryset(self):
        return MusicGenre.objects.all()
