# -*- coding: utf-8 -*-
import urllib.parse


def _get_cluster_name(path):
    for it in path.split('/'):
        if it:
            return it


def _get_table_path(query):
    query_path = query.get('path')
    if query_path:
        return query_path[0]


def get_table_name(url):
    p = urllib.parse.urlparse(url)
    query = urllib.parse.parse_qs(p.query)
    cluster_name = _get_cluster_name(p.path)
    table_path = _get_table_path(query)
    return (cluster_name, table_path)


def get_table_id(cluster_name, table_path):
    return f'{table_path}_{cluster_name}'
