# -*- coding: utf-8 -*-
from rest_framework import serializers
from events.accounts.models import User, CHOICES_UID_TYPE

from events.followme.models import ContentFollower
from events.rest_framework_contrib.serializers import InternalModelSerializerV2Mixin


class UserFollowerSerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    name_and_surname_with_fallback = serializers.CharField(source='get_name_and_surname_with_fallback', read_only=True)
    yandex_username = serializers.CharField(source='get_yandex_username', read_only=True)
    uid = serializers.CharField(read_only=True)

    class Meta:
        model = User
        fields = (
            'id',
            'name_and_surname_with_fallback',
            'yandex_username',
            'uid',
            'cloud_uid',
        )


class UserUidOnlySerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    uid = serializers.CharField(read_only=True)

    class Meta:
        model = User
        fields = (
            'id',
            'uid',
            'cloud_uid',
        )


class ContentFollowerSerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    profile = UserFollowerSerializer(read_only=True, source='user')

    class Meta:
        model = ContentFollower
        fields = (
            'id',
            'email',
            'profile',
            'type',
        )


class ContentFollowerKeepOnlyItemSerializer(serializers.Serializer):
    type = serializers.ChoiceField(choices=['user', 'mail_list'])
    email = serializers.CharField(required=False, allow_null=True)
    login = serializers.CharField(required=False, allow_null=True)
    uid = serializers.CharField(required=False, allow_null=True)
    cloud_uid = serializers.CharField(required=False, allow_null=True)


class ContentFollowerKeepOnlySerializer(serializers.Serializer):
    auth_type = serializers.ChoiceField(choices=CHOICES_UID_TYPE, default='internal', required=False)
    followers = ContentFollowerKeepOnlyItemSerializer(many=True)
