# Generated by Django 2.2.17 on 2020-12-17 06:26

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
from events.common_app.fields import IdentifierField


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ProfileFollowContent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='creation_date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='date_of_change')),
                ('object_id', IdentifierField(blank=True, null=True)),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='contenttypes.ContentType')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'content_type', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='ContentFollower',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='creation_date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='date_of_change')),
                ('type', models.CharField(choices=[('user', 'Пользователь'), ('mail_list', 'Рассылка')], default='user', max_length=10, verbose_name='Тип')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='Email')),
                ('object_id', IdentifierField(blank=True, null=True)),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='contenttypes.ContentType')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('email', 'content_type', 'object_id'), ('user', 'content_type', 'object_id')},
            },
        ),
    ]
