# -*- coding: utf-8 -*-
from django.db import migrations, models
from events.common_app.utils import generate_code


def update_extra(apps, schema_editor):
    queryset = apps.get_model('followme', 'ContentFollower').objects.filter(type='user')
    for content_follower in queryset:
        content_follower.secret_code = generate_code()
        content_follower.save(update_fields=['secret_code'])


class Migration(migrations.Migration):
    dependencies = [
        ('followme', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='ContentFollower',
            name='secret_code',
            field=models.CharField(max_length=255, blank=True, null=True, db_index=True),
        ),
        migrations.RunPython(update_extra)
    ]
