# -*- coding: utf-8 -*-
from rest_framework import viewsets

from events.geobase_contrib.api_admin.v2.filters import CityFilter
from events.geobase_contrib.api_admin.v2.serializers import CitySerializer
from events.geobase_contrib.models import City
from events.rest_framework_contrib.mixins import InternalGenericApiViewV2Mixin


class CityViewSet(InternalGenericApiViewV2Mixin, viewsets.ReadOnlyModelViewSet):
    serializer_class = CitySerializer
    queryset = City.objects.all()
    filter_class = CityFilter
