# -*- coding: utf-8 -*-
from events.common_app.utils import add_model_prefix as add
from events.search.utils import ORMFullTextSearchConstructor


class RegionConditions(object):
    @classmethod
    def is_fit_for_search_text(cls, search_text, model_instance=None, prefix=None):
        if model_instance:
            raise NotImplementedError()
        else:
            condition = ORMFullTextSearchConstructor(
                prefix=prefix,
                localizable_params=[
                    add(prefix, to='name'),
                ]
            ).get_q_objects_for_text(search_text=search_text)

        return condition
