# -*- coding: utf-8 -*-
import factory

from events.geobase_contrib.models import City, Country


class RegionFactory(factory.django.DjangoModelFactory):
    class Meta:
        abstract = True

    geobase_id = factory.Sequence(lambda n: n)


class CountryFactory(RegionFactory):
    class Meta:
        model = Country


class CityFactory(RegionFactory):
    class Meta:
        model = City

    country = factory.SubFactory(factory=CountryFactory)
