# -*- coding: utf-8 -*-
from django.db.models import Manager
from django.db.models.query import QuerySet

from events.common_app.managers import ProxyToQuerySetMixin
from events.translation.managers import TranslationQuerySetMixin


class RegionQuerySet(TranslationQuerySetMixin, QuerySet):
    def filter_by_fit_for_search_text(self, search_text):
        return self.filter_translated_fields(search_text, 'full_name')


class RegionManager(ProxyToQuerySetMixin, Manager):
    queryset_class = RegionQuerySet

    def get_queryset(self):
        return self.queryset_class(self.model, using=self._db)
