# -*- coding: utf-8 -*-
from rest_framework import serializers

from events.geobase_contrib.models import City, Country


class RegionSerializerBase(serializers.ModelSerializer):
    class Meta:
        fields = (
            'id',
            'name',
            'full_name',
            'geobase_id',
        )


class CountrySerializer(RegionSerializerBase):
    class Meta(RegionSerializerBase.Meta):
        model = Country


class CitySerializer(serializers.ModelSerializer):
    country = CountrySerializer()

    class Meta(RegionSerializerBase.Meta):
        model = City
        fields = RegionSerializerBase.Meta.fields + (
            'country',
        )
