# -*- coding: utf-8 -*-
from rest_framework import viewsets

from events.geobase_contrib.models import City, Country
from events.geobase_contrib.serializers import (
    CitySerializer,
    CountrySerializer,
)
from events.rest_framework_contrib.mixins import ExternalGenericApiViewV1Mixin


class CountryViewSet(ExternalGenericApiViewV1Mixin,
                     viewsets.ReadOnlyModelViewSet):
    create_on_missing = False

    serializer_class = CountrySerializer
    queryset = Country.objects.all()


class CityViewSet(ExternalGenericApiViewV1Mixin,
                  viewsets.ReadOnlyModelViewSet):
    create_on_missing = False

    serializer_class = CitySerializer
    queryset = City.objects.all().select_related('country')
