# -*- coding: utf-8 -*-
import django_filters

from django.conf import settings
from django.contrib.contenttypes.models import ContentType
from django.db.models import Q

from events.history.models import HistoryRawEntry
from events.surveyme.models import Survey, SurveyQuestion, SurveyText


class HistoryRawEntryFilter(django_filters.FilterSet):
    object_id = django_filters.CharFilter(method='get_with_relations')

    class Meta:
        model = HistoryRawEntry
        fields = (
            'content_type',
            'object_id',
        )

    def get_with_relations(self, queryset, name, value):
        if 'content_type' not in self.data:
            ct = ContentType.objects.get_for_models(Survey, SurveyQuestion, SurveyText)
            questions_qs = (
                SurveyQuestion.with_deleted_objects.filter(survey_id=value)
                .values_list('pk', flat=True)
                .order_by()
            )
            texts_qs = (
                SurveyText.objects.filter(survey_id=value)
                .values_list('pk', flat=True)
            )
            if settings.IS_BUSINESS_SITE:
                questions_qs = map(str, questions_qs)
                texts_qs = map(str, texts_qs)
            queryset = queryset.filter(
                Q(content_type=ct[Survey], object_id=str(value))
                | Q(content_type=ct[SurveyQuestion], object_id__in=questions_qs)
                | Q(content_type=ct[SurveyText], object_id__in=texts_qs)
            )
        else:
            queryset = queryset.filter(object_id=value)
        return queryset
