# -*- coding: utf-8 -*-
from rest_framework import serializers

from events.followme.api_admin.v2.serializers import UserFollowerSerializer
from events.history.models import HistoryRawEntry
from events.rest_framework_contrib.serializers import InternalModelSerializerV2Mixin


class HistoryRawEntrySerializer(InternalModelSerializerV2Mixin, serializers.ModelSerializer):
    profile = UserFollowerSerializer(source='user', read_only=True)
    info = serializers.DictField(source='get_info')

    class Meta:
        model = HistoryRawEntry
        fields = (
            'id',
            'date_created',
            'profile',
            'info',
            'content_type',
            'object_id',
        )
