# -*- coding: utf-8 -*-
from rest_framework import viewsets

from events.history.api_admin.v2.filters import HistoryRawEntryFilter
from events.history.api_admin.v2.serializers import HistoryRawEntrySerializer
from events.history.models import HistoryRawEntry
from events.rest_framework_contrib.mixins import InternalGenericApiViewV2Mixin


class HistoryEntryViewSet(InternalGenericApiViewV2Mixin, viewsets.ReadOnlyModelViewSet):
    serializer_class = HistoryRawEntrySerializer
    queryset = (
        HistoryRawEntry.objects.all()
        .order_by('-date_created')
    )
    filter_class = HistoryRawEntryFilter
