# -*- coding: utf-8 -*-
from django.db import models
from django.conf import settings
from django.contrib.contenttypes.models import ContentType


class HistoryEntryManager(models.Manager):
    pass


class HistoryRawEntryManager(models.Manager):
    def _get_body(self):
        from events.common_app.middleware import get_current_request_body
        return get_current_request_body()

    def _get_content_type(self, request):
        return request.META.get('CONTENT_TYPE')

    def _get_endpoint(self, request):
        if request.resolver_match.namespace:
            return '%s:%s' % (request.resolver_match.namespace, request.resolver_match.url_name)
        return request.resolver_match.url_name

    def _get_user(self, request):
        user = request.user
        if not user:
            return settings.ROBOT_USER_ID
        return user.pk

    def create_entry(self, obj):
        from events.common_app.middleware import get_current_request
        content_type = ContentType.objects.get_for_model(type(obj))
        request = get_current_request()

        history_entry = self.model(
            user_id=self._get_user(request),
            path=request.path,
            endpoint=self._get_endpoint(request),
            method=request.method,
            request=self._get_body(),
            request_content_type=self._get_content_type(request),
            content_type=content_type,
            object_id=obj.pk,
        )

        return history_entry.save()

    def create_raw_entry(self, request, content_type: ContentType, object_id: str):
        history_entry = self.model(
            user_id=self._get_user(request),
            path=request.path,
            endpoint=self._get_endpoint(request),
            method=request.method,
            request=self._get_body(),
            request_content_type=self._get_content_type(request),
            content_type=content_type,
            object_id=object_id,
        )
        return history_entry.save()
