# -*- coding: utf-8 -*-
from events.history.models import HistoryRawEntry


class HistoryMixin:
    def perform_update(self, serializer):
        HistoryRawEntry.objects.create_entry(serializer.instance)
        return super().perform_update(serializer)

    def perform_create(self, serializer):
        super().perform_create(serializer)
        HistoryRawEntry.objects.create_entry(serializer.instance)

    def perform_destroy(self, obj):
        HistoryRawEntry.objects.create_entry(obj)
        return super().perform_destroy(obj)
