# -*- coding: utf-8 -*-
from django.contrib.contenttypes.fields import GenericForeignKey
from django.db import models

from events.accounts.models import User
from events.common_app.fields import IdentifierField
from events.history.actions import get_action_info
from events.history.managers import HistoryRawEntryManager


METHOD_TYPES = (
    ('POST', 'POST'),
    ('PATCH', 'PATCH'),
    ('PUT', 'PUT'),
    ('DELETE', 'DELETE'),
)


class HistoryRawEntry(models.Model):
    date_created = models.DateTimeField(auto_now=True)
    request = models.TextField(blank=True, null=True)
    request_content_type = models.TextField(blank=True, null=True)
    method = models.CharField(choices=METHOD_TYPES, max_length=6)
    path = models.TextField(blank=True, null=True)
    endpoint = models.TextField(blank=True, null=True)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    content_type = models.ForeignKey('contenttypes.ContentType', on_delete=models.DO_NOTHING)
    object_id = IdentifierField(db_index=True)
    content_object = GenericForeignKey()

    objects = HistoryRawEntryManager()

    def get_info(self):
        return {
            'template': get_action_info(self),
        }
