# -*- coding: utf-8 -*-
from django.conf import settings
from django.contrib.contenttypes.models import ContentType
from json import dumps as json_dumps

from events.history.models import HistoryRawEntry
from events.surveyme.models import Survey


def create_publication_history_entry(survey_id, publication_status):
    ct = ContentType.objects.get_for_model(Survey)
    user_id = settings.ROBOT_USER_ID
    endpoint = 'admin_api_v2:survey-detail'
    method = 'PATCH'
    path = '/admin/api/v2/surveys/%s/' % survey_id
    request = json_dumps({'is_published_external': publication_status})
    request_content_type = 'application/json'

    history_entry = HistoryRawEntry(
        user_id=user_id,
        endpoint=endpoint,
        method=method,
        path=path,
        request=request,
        request_content_type=request_content_type,
        content_type=ct,
        object_id=survey_id,
    )
    return history_entry
