# -*- coding: utf-8 -*-
from django.conf import settings

from django.core.exceptions import ValidationError
from django.utils.translation import ugettext as _
from rest_framework import serializers
from rest_framework.fields import ReadOnlyField

from events.media.models import Image
from events.rest_framework_contrib.fields import ImageField
from events.rest_framework_contrib.serializers import ForeignKeyMixin


class ImageSerializer(ForeignKeyMixin, serializers.ModelSerializer):
    links = ImageField(
        sizes=settings.IMAGE_SIZES,
        source='image', read_only=True,
    )
    name = ReadOnlyField()

    class Meta:
        model = Image
        fields = (
            'id',
            'links',
            'name',
            'image',
            'is_system',
        )
        extra_kwargs = {
            'image': {'write_only': True},
        }

    def validate_image(self, value):
        if value.size > settings.IMAGE_MAX_SIZE * 1000000:
            raise ValidationError(_('max_file_size_exceeded') % {'max_file_size': settings.IMAGE_MAX_SIZE})
        return value
