# -*- coding: utf-8 -*-
from django.utils.translation import ugettext as _
from requests.exceptions import HTTPError
from rest_framework import viewsets
from rest_framework.exceptions import ValidationError

from events.media.api_admin.v2.filters import ImageFilter
from events.media.api_admin.v2.serializers import ImageSerializer
from events.media.models import Image


class ImageView(viewsets.ModelViewSet):
    queryset = Image.objects.all()
    serializer_class = ImageSerializer
    filter_class = ImageFilter

    def perform_create(self, serializer):
        try:
            super(ImageView, self).perform_create(serializer)
        except HTTPError:
            raise ValidationError(_('Произошла ошибка при загрузке файла, пожалуйста, попробуйте еще раз'))
