# -*- coding: utf-8 -*-
import binascii
import factory
import os

from events.media.models import Image


def generate_image_path():
    image_path = binascii.hexlify(os.urandom(18)).decode()
    return '%s/%s' % (image_path[:4], image_path[4:])


class ImageFactory(factory.django.DjangoModelFactory):
    class Meta:
        model = Image

    image = factory.LazyFunction(generate_image_path)
    name = factory.Sequence(lambda n: 'Image_{n}'.format(n=n))
