# -*- coding: utf-8 -*-
from django.db import models
from django.db.models.fields.files import ImageFieldFile as BaseImageFieldFile


from events.avatars_extra.storage import AvatarsStorage


class ImageFieldFile(BaseImageFieldFile):
    def get_thumb_url(self, *args, **kwargs):
        """Proxy на метод self.storage._get_thumb_url"""
        args = list(args)
        args.insert(0, self.name)
        return self.storage._get_thumb_url(*args, **kwargs)


class ImageField(models.ImageField):
    attr_class = ImageFieldFile

    def __init__(self, *args, **kwargs):
        namespace = kwargs.pop('namespace', None)
        kwargs.setdefault('storage', AvatarsStorage(namespace=namespace))
        self.storage = AvatarsStorage(namespace=namespace)
        super(ImageField, self).__init__(*args, **kwargs)
