# -*- coding: utf-8 -*-
from django.db import models
from django.conf import settings
from django.utils.six import python_2_unicode_compatible

from events.media.fields import ImageField


@python_2_unicode_compatible
class Image(models.Model):
    image = ImageField(namespace=settings.IMAGE_NAMESPACE)
    name = models.CharField(max_length=1000)
    is_system = models.NullBooleanField('Системная', default=False)

    def save(self, *args, **kwargs):
        if not self.name:
            self.name = self.image.name
        return super(Image, self).save(*args, **kwargs)

    def __str__(self):
        return self.name
