# -*- coding: utf-8 -*-
from django.conf import settings


def get_image_links(image):
    return {
        size: '{host}get-{namespace}/{path}/{size}'.format(
            host=settings.AVATARS_HOST,
            namespace=settings.IMAGE_NAMESPACE,
            path=image.image,
            size=size,
        )
        for size in settings.IMAGE_SIZES_AS_STR
    }
