# -*- coding: utf-8 -*-

def monkey_patch_http_request():
    from django.conf import settings
    from http.client import HTTPSConnection

    def mock_request(orig_request):
        def mocked_func(self, method, url, body=None, headers=None):
            headers = headers or {}

            if not settings.IS_BUSINESS_SITE:
                if self.host == 'jing.yandex-team.ru':
                    header_keys = {
                        header_key.lower(): header_key
                        for header_key in headers.keys()
                    }
                    if 'authorization' not in header_keys:
                        headers['Authorization'] = 'OAuth %s' % settings.STAFF_OAUTH_ACCESS_TOKEN

            return orig_request(self, method, url, body, headers)
        return mocked_func

    HTTPSConnection.request = mock_request(HTTPSConnection.request)
