# -*- coding: utf-8 -*-
from django.conf import settings
from events.common_app.clients import BaseClient


class MusicGenreClient(BaseClient):
    title_format = '{genre} \u2192 {subgenre}'
    results_key = 'result'

    def get_subgenre_title(self, title, subtitle):
        return self.title_format.format(genre=title, subgenre=subtitle)

    def process_one_item(self, genre):
        translations = {
            'title': {
                lang: data['title']
                for lang, data in genre['titles'].items()
            },
        }
        yield {
            'music_id': genre['id'],
            'title': translations['title'].get('ru'),
            'translations': translations,
        }

        for subgenre in genre.pop('subGenres', []):
            subtranslations = {
                'title': {
                    lang: self.get_subgenre_title(translations['title'].get(lang), data['title'])
                    for lang, data in subgenre['titles'].items()
                },
            }
            yield {
                'music_id': subgenre['id'],
                'title': subtranslations['title'].get('ru'),
                'translations': subtranslations,
            }

    def get_url(self):
        return settings.MUSIC_GENRE_URL
