# -*- coding: utf-8 -*-
from django.core.management.base import BaseCommand
from events.common_app.utils import YLockCommandMixin

from events.music.models import MusicGenre


class MainCommand(BaseCommand):
    help = """Синхронизирует жанры музыки"""

    def handle(self, *args, **options):
        MusicGenre.objects.sync_with_source()


class Command(YLockCommandMixin, MainCommand):
    lock_name = 'events.sync_music_genres'
