# -*- coding: utf-8 -*-
import json
from django.db import models

from events.common_app.models import Md5sumMixin
from events.music.managers import MusicGenreManager
from events.translation.models import TranslationModel


class MusicGenre(Md5sumMixin, TranslationModel):
    FIELDS_FOR_TRANSLATION = ('title', )

    music_id = models.CharField(max_length=32, unique=True, db_index=True)
    title = models.CharField(max_length=256)
    tracks_count = models.PositiveIntegerField(default=0)

    objects = MusicGenreManager()

    def __str__(self):
        return 'Жанр "%s"' % self.title

    @classmethod
    def calc_md5sum(cls, title, translations):
        return cls._calc_md5sum(
            title,
            json.dumps(translations, sort_keys=True, ensure_ascii=False),
        )

    def md5(self):
        return self.calc_md5sum(
            self.title,
            self.translations,
        )

    def get_title(self):
        return self.get_translated_field('title')
