# -*- coding: utf-8 -*-

from collections.abc import Iterable
from rest_framework.utils import encoders
from rest_framework.exceptions import ValidationError as RestValidationError
from events.surveyme_integration.exceptions import WikiIntegrationError


class JSONEncoder(encoders.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, RestValidationError):
            if isinstance(obj.detail, Iterable):
                return [str(value) for value in obj.detail]
            return str(obj.detail)
        elif isinstance(obj, WikiIntegrationError):
            return obj.cause
        elif isinstance(obj, Exception):
            return str(obj)
        return super().default(obj)
