# -*- coding: utf-8 -*-
import sys
from django.core.paginator import Paginator as DjangoPaginator
from rest_framework.pagination import PageNumberPagination


class StandardPagination(PageNumberPagination):
    page_size = 10
    page_size_query_param = 'page_size'
    max_page_size = 200

    def get_page_size(self, request):
        if request.query_params.get(self.page_size_query_param) == 'max':
            return self.max_page_size
        return super(StandardPagination, self).get_page_size(request)


class LargePagination(StandardPagination):
    page_size = 100
    max_page_size = sys.maxsize


class FetchDjangoPaginator(DjangoPaginator):
    def page(self, number):
        number = self.validate_number(number)
        bottom = (number - 1) * self.per_page
        top = bottom + self.per_page
        if top + self.orphans >= self.count:
            top = self.count

        data = []
        for i, obj in enumerate(self.object_list):
            if i < bottom:
                continue
            if i < top:
                data.append(obj)
            else:
                break
        return self._get_page(data, number, self)


class FetchPagination(StandardPagination):
    django_paginator_class = FetchDjangoPaginator


class OneItemPagination(PageNumberPagination):
    page_size = 1
    max_page_size = 1
    page_query_param = 'item'
