# -*- coding: utf-8 -*-
from rest_framework.throttling import SimpleRateThrottle


class UserOrIpRateBaseThrottle(SimpleRateThrottle):
    def get_identity(self, request):
        if request.yauser.is_authenticated() and request.user:
            ident = request.user.pk
        else:
            ident = request.META.get('REMOTE_ADDR', None)
        return ident

    def get_cache_key(self, request, view):
        return self.cache_format % {
            'scope': self.scope,
            'ident': self.get_identity(request)
        }
