# -*- coding: utf-8 -*-
from django.conf import settings

from events.common_app.keyfile import cachekeys


def get_validation_mixture_key(api_name):
    return cachekeys['validation_mixture'].format(api_name=api_name)


def connect_cache_invalidator(router):
    from events.common_app.utils import import_from_string
    from events.rest_framework_contrib.signal_handlers import (
        post_save_invalidate_api_signal_handler,
        post_delete_invalidate_api_signal_handler,
    )
    from django.db.models.signals import post_save, post_delete

    querysets = [resource.queryset for _, resource, _ in router.registry]

    if hasattr(settings, 'REST_FRAMEWORK_ADDITIONAL_QUERYSETS_FOR_CACHE_INVALIDATION'):
        for model_path, get_queryset_func in settings.REST_FRAMEWORK_ADDITIONAL_QUERYSETS_FOR_CACHE_INVALIDATION:
            model = import_from_string(model_path, settings.REST_FRAMEWORK_ADDITIONAL_QUERYSETS_FOR_CACHE_INVALIDATION)
            queryset = get_queryset_func(model)
            querysets.append(queryset)

    for queryset in querysets:
        try:
            model = queryset.model
        except AttributeError:
            continue
        if not hasattr(model._meta, '_queryset_list'):
            queryset.model._meta._queryset_list = []
        queryset.model._meta._queryset_list.append(queryset)
        post_save.connect(receiver=post_save_invalidate_api_signal_handler, sender=queryset.model)
        post_delete.connect(receiver=post_delete_invalidate_api_signal_handler, sender=queryset.model)
