# -*- coding: utf-8 -*-

from django.conf import settings
from rest_framework.views import exception_handler as orig_exception_handler
from events.rest_framework_contrib.exceptions import PermissionDenied


def exception_handler(exc, context):
    response = orig_exception_handler(exc, context)

    if isinstance(exc, PermissionDenied):
        if settings.IS_BUSINESS_SITE:
            response.data['reason'] = exc.reason

    return response
